// SETTINGS MANAGEMENT

GIWIK.init.js(['css','msg'],'settings_management');



// Elaboration du nom de fichier de sauvegarde de la configuration
// Settings + NomProduit + NumeroSerie + Date
HEADING.updateSettingsFileName = function ()
{
	var current_date    = new Date();
	var current_year    = current_date.getFullYear()-2000;  if (current_year < 10)  {current_year = '0' + current_year};
	var current_month   = current_date.getMonth() + 1; 	if (current_month < 10) {current_month = '0' + current_month};
	var current_day     = current_date.getDate(); 		if (current_day < 10)   {current_day = '0' + current_day};

	var filename = "";

	// Settings
	if (GIWIK.lang == 'fr')
	{
		filename += "Config_";
	}
	else
	{
		filename += "Settings_";
	}

	// Nom du fichier
	filename += GIWIK.system_name.replace(/[_\s]/,'-')+"_"		// Nom du Produit
			 +  System_state.SerialNumber+"_"					// Serial Number
			 +  ""+current_year+""+current_month+""+current_day	// Date Heure
			 +  ".txt";

	window.SaveSettings_InputFile.setValue(filename);
};

// Affichage Message lié SaveSettings (OK ou erreur)
HEADING.updateSettingsSaveUsrMsg = function (msg_code)
{
	window.Usermsg_SaveSettings.setStatus(MSG.defineState(msg_code));
	window.Usermsg_SaveSettings.setValue(MSG(['settingsstatuscode',msg_code]));
	window.Usermsg_SaveSettings.show();

	// Msg = Fin procedure Sauvegarde settings => Activation Bouttons
	if (window.SaveSettings_Button instanceof Button)
	{
		window.SaveSettings_Button.enable();
	}
	if (window.RestoreSettings_Button instanceof Button)
	{
		window.RestoreSettings_Button[(window.RestoreSettings_InputFile.getValue()) ? 'enable' : 'disable']();
	}
};

// Affichage Message lié RestoreSettings (OK ou erreur)
HEADING.updateSettingsRestoreUsrMsg = function (msg_code)
{
	window.Usermsg_RestoreSettings.setStatus(MSG.defineState(msg_code));
	window.Usermsg_RestoreSettings.setValue(MSG(['settingsstatuscode',msg_code]));
	window.Usermsg_RestoreSettings.show();

	// Msg = Fin procedure restauration settings => Activation Bouttons
	if (window.SaveSettings_Button instanceof Button)
	{
		window.SaveSettings_Button.enable();
	}
	if (window.RestoreSettings_Button instanceof Button)
	{
		window.RestoreSettings_Button[(window.RestoreSettings_InputFile.getValue()) ? 'enable' : 'disable']();
	}
};

// Step1 pour sauvegarde: Demande au Firmware de construire le fichier de config du produit
HEADING.createSettingsFile = function ()
{
	// Indication demande en cours
	HEADING.create_setting_file_in_progress = true;

	//  Requete Firmware creation Fichier de Config
	GIWIK.ajax(GIWIK.cgifile+"?mode=3"+"&SaveSettings");

	// Demarrage Timer de 3s pour attente reponse Firmware
	// - Si pas de reponse: Message Erreur Sauvegarde config file
	setTimeout("HEADING.createSettingsFileTimeOut();", 3000);
};

// Time Out à la création du fichier de settings: Pas de Reponse du Firmware: Message Erreur
HEADING.createSettingsFileTimeOut = function ()
{
	if (HEADING.create_setting_file_in_progress == true)
	{
		// Message de Alert: pas de reponse de l'embarque
		HEADING.updateSettingsSaveUsrMsg('2004');
	}
};

// Step2 pour sauvegarde: Demande de transfert (download du fichier de config)
HEADING.downloadSettingsFile = function ()
{
	// Traitement reponse à la demande de creation fichier de settings
	if (HEADING.create_setting_file_in_progress == true)
	{
		// Fin Creation Fichier Settings
		HEADING.create_setting_file_in_progress = false;

		// Succes Creation Fichier de Config par Firmware
		if (System_state.SaveSettings != "")
		{
			// Message OK
			HEADING.updateSettingsSaveUsrMsg('1');

			// Demande Download Fichier
			window.location.href = GIWIK.cgidownloader+'?url='+window.location.protocol+'//'+window.location.host+window.location.pathname+'&settingsfilename='+System_state.SaveSettings+'&outputfilename='+window.SaveSettings_InputFile.getValue();
		}
		// Echec
		else
		{
			// Message de Alert
			HEADING.updateSettingsSaveUsrMsg('2002');
		}
	}
};

// Step 1 pour restauration des settings: Envoi commande RestoreSettings: permet de detecter si le firmware gere la restauration des settings
HEADING.initRestoreSettingsFile = function ()
{
	// Indication demande en cours
	window.RestoreSettingsFileInProgress = true;

	// Requete pour pour autoriser ou non la restauration des parametres reseau
	GIWIK.ajax(GIWIK.cgifile+"?mode=4"+"&RestoreNetwork=" + window.RestoreNetwork_InputCheckbox.value);	
	
	//  Requete Firmware Restore Settings Enable ?
	GIWIK.ajax(GIWIK.cgifile+"?mode=3"+"&RestoreSettings");

	// Demarrage Timer de 2s pour attente reponse Firmware
	// - Si pas de reponse: Message Erreur Retauration Settings (Non géré par le Firmware)
	setTimeout("HEADING.initRestoreSettingsFileTimeOut();", 2000);
};

// Time Out pour Reponse Restore Settings
HEADING.initRestoreSettingsFileTimeOut = function ()
{
	if (window.RestoreSettingsFileInProgress == true)
	{
		// Message de Alert: pas de reponse de l'embarque
		HEADING.updateSettingsRestoreUsrMsg('2004');
	}
};

// Step 2 pour restauration des settings: Restauration proprement dite: POST fichier settings via CGIuploader
HEADING.restoreSettingsFile = function ()
{
	// Traitement reponse à la demande de resaturation des settings
	if (window.RestoreSettingsFileInProgress == true)
	{
		// Succes Restauration Settings
		if (System_state.RestoreSettings != "")
		{
			// Appel Formualire cgi pour retauration settings
			document.form_restore.submit();
		}
		// Echec Restauration
		else
		{
			// Message de Alert
			HEADING.updateSettingsRestoreUsrMsg('2002');
		}
		window.RestoreSettingsFileInProgress = false;
	}
};

HEADING.readConf._plugins.settings_management = function (option)
{
	//l'action de sauvegarde en prom des paramètres utilisateurs suite à chargement d'un fichier de conf est fait automatiquement par l'embarqué
	//le web n'a pas besoin d'envoyer une requete cmd=2 en plus.
	GIWIK.save_to_prom_needed = false;
	
	// Init Nom du Fichier
	if (window.FileNameInit != 1)
	{
		HEADING.updateSettingsFileName();
		window.FileNameInit = 1;
	}

	if (HEADING.init.isdone)
	{
		// Traitement Reponse Demande Creation Fichier Config
		HEADING.downloadSettingsFile();

		// Traitement Reponse Demande Init Restauration
		HEADING.restoreSettingsFile();
	}
};

HEADING.getConf._plugins.settings_management = function (option)
{
	var _params = {};

	_params['SerialNumber'] = "";

	return _params;
};

HEADING.construct._plugins.settings_management = function ()
{
	var ie_floatleft  = ' style="float:left"';
	var ie_floatright = ' style="float:right"';

	var cnt = ''

	// Save Configuration
	+'<div id="usermsg_savesettings"></div>'

	//+'<div id="save_settings_intro" class="box_leftintro"></div>'

	+'<div id="save_settings_name"></div>'
	+'<div id="savesettings"></div>';

	$('#content').append(GIWIK.box(cnt, MSG(['box','save_settings_title']), false, ['box_save_settings'], ['', 'box_content_nopadding']));


	// Restore Configuration
	cnt = '<table>'
			+'<tbody>'
				+'<tr>'
					+'<div id="usermsg_restoresettings"></div>'
				+'</tr>'
				+'<tr>'
					+'<td>'
						//+'<div id="restore_settings_intro" class="box_leftintro"></div>'
						+'<div id="restore_settings_name"></div>'					
						+'<div id="restoreNetwork_InputCheckbox"></div>'					
					+'</td>'
					+'<td>'
						+'<div id="restoresettings"></div>'					
					+'</td>'
				+'</tr>'
			+'</tbody>'
		+'</table>';
	
	
	
			
	$('#content').append(GIWIK.box(cnt, MSG(['box','restore_settings_title']), false, ['box_restore_settings'], ['', 'box_content_nopadding']));


	// Nom Fichier pour Sauvegarde
	window.SaveSettings_InputFile = new Input_text('SaveSettings_InputFile', false);
	window.SaveSettings_InputFile.margin = '35px 0 12px 0';
	window.SaveSettings_InputFile.label_width = (GIWIK.lang == 'fr') ? 42 : 25;
	window.SaveSettings_InputFile.input_width = (GIWIK.lang == 'fr') ? 240 : 257;
	window.SaveSettings_InputFile.text_align = 'left';
	window.SaveSettings_InputFile.construct('save_settings_name','linear',MSG(['parameters','file']),'',false);
	window.SaveSettings_InputFile.enable();
	window.SaveSettings_InputFile.show();


	// Boutton Sauvegarde config
	window.SaveSettings_Button = new Button('SaveSettings_Button', false);
	window.SaveSettings_Button.construct('savesettings', MSG(['buttons','savesettings']));
	window.SaveSettings_Button.setAction("window.Usermsg_RestoreSettings.hide();window.SaveSettings_Button.disable();window.RestoreSettings_Button.disable();HEADING.createSettingsFile();");
	window.SaveSettings_Button.enable();
	window.SaveSettings_Button.show();


	// Fichier pour restauration
	window.RestoreSettings_InputFile = new Input_file('RestoreSettings_InputFile', false);
	//window.RestoreSettings_InputFile.margin = '35px 0 0 0';
	window.RestoreSettings_InputFile.label_width = (GIWIK.lang == 'fr') ? 42 : 25;
	window.RestoreSettings_InputFile.construct('restore_settings_name',MSG(['parameters','file']),{form_name:'form_restore',form_action:GIWIK.cgiuploader+'?url='+window.location.protocol+'//'+window.location.host+window.location.pathname+'&settings=true',input_name:'Filedata'},false);
	window.RestoreSettings_InputFile.setAction("window.RestoreSettings_Button.enable();");
	window.RestoreSettings_InputFile.enable();
	window.RestoreSettings_InputFile.show();

	window.RestoreNetwork_InputCheckbox = new Input_checkbox('RestoreNetwork_InputCheckbox');	
	window.RestoreNetwork_InputCheckbox.construct('restoreNetwork_InputCheckbox', 'linear', '', [0, 1], false);
	window.RestoreNetwork_InputCheckbox.setAction('');
	window.RestoreNetwork_InputCheckbox.enable();		
	
	$("#restoreNetwork_InputCheckbox").find("td").last().after('<td id= "restorenetwork_label" class= "chkbox_label_right"></td>');
	$("#restorenetwork_label").text(MSG(['parameters','restoreNetwork']));
	
	$("#restoreNetwork_InputCheckbox").css({display:'inline-block'});
	
	/*
	window.RestoreNetwork_InputRadio = new Input_radio('RestoreNetwork_InputRadio', true);
	window.RestoreNetwork_InputRadio.margin = "15px 0 0 0";
	window.RestoreNetwork_InputRadio.construct('restoreNetwork_InputRadio','groupName','linear',MSG(['parameters','restoreNetwork']),1,true);
	window.RestoreNetwork_InputRadio.setAction();
	window.RestoreNetwork_InputRadio.show();	
	*/
	// Boutton Restauration config
	window.RestoreSettings_Button = new Button('RestoreSettings_Button', false);
	window.RestoreSettings_Button.construct('restoresettings', MSG(['buttons','restoresettings']));
	window.RestoreSettings_Button.setAction("window.Usermsg_SaveSettings.hide();window.SaveSettings_Button.disable();window.RestoreSettings_Button.disable();HEADING.initRestoreSettingsFile();");
	window.RestoreSettings_Button[(window.RestoreSettings_InputFile.getValue()) ? 'enable' : 'disable']();
	window.RestoreSettings_Button.show();


	window.Usermsg_SaveSettings = new User_msg('Usermsg_SaveSettings', false);
	window.Usermsg_SaveSettings.margin = '5px 0 10px 0';
	window.Usermsg_SaveSettings.construct('usermsg_savesettings', 3, "");
	window.Usermsg_SaveSettings.hide();

	window.Usermsg_RestoreSettings = new User_msg('Usermsg_RestoreSettings', false);
	window.Usermsg_RestoreSettings.margin = '5px 0 10px 0';
	window.Usermsg_RestoreSettings.construct('usermsg_restoresettings', 3, "");
	window.Usermsg_RestoreSettings.hide();
	
	// Message d'erreur lié à la sauvegarde des settings
	if (window._GET['savesettingserror'] && window._GET['savesettingserror'].match(/^[0-9]+$/gi))
	{
		var settings_code = window._GET['savesettingserror'];

		if (MSG['settingsstatuscode'][settings_code])
		{
			HEADING.updateSettingsSaveUsrMsg(settings_code);
		}
	}

	// Message de reponse lié à la restauration des settings
	if (window._GET['restoresettingserror'] && window._GET['restoresettingserror'].match(/^[0-9]+$/gi))
	{
		var settings_code = window._GET['restoresettingserror'];

		// Restore Settings OK
		if (settings_code == 0)
		{
			settings_code = 2;
		}
		// Load GPS Setting OK
		else if (settings_code == 1)
		{
			settings_code = 3;
		}
		// Error
		else if (!MSG['settingsstatuscode'][settings_code])
		{
			settings_code = 2002;
		}

		HEADING.updateSettingsRestoreUsrMsg(settings_code);
		window.RestoreSettingsFileInProgress = false;
	}
};